 
'--------------------------------------------------RM SafetyNet SSL Certificate Deployment.vbs------------------------------------------------------

 'Script to create and link the Group Policy Object (GPO) to deploy the SafetyNet trusted root certificate to the network.
 'Copyright � 2014 RM. All rights reserved.
'---------------------------------------------------------------------------------------------------------------------------------------

'Option Explicit 

'--------------------------------------------Global variables and constants----------------------------------------------------------------------------------------

Dim ObjRootDSE, ParentOU, strGPO, strADsPathDNC, strDomain, objGPM, objGPMConstants, objGPMDomain, strDNC, strCC4OUName, _
 StrDomName, CurrentExecutionDirectory, objShell, objFSO, strLogFileName, strErrorMessage, strWarningMessage, strGPOUpdateTool, strSslCertRegFragment, strMessageBoxTitle, objProgressMsg

'--------------------------------------------Global variables and constants----------------------------------------------------------------------------------------
  On Error Resume Next 
  
  Initialize() 'Entry Point

  On Error GoTo 0
  
'---------------------------------------------
' Initialize the operation
'---------------------------------------------

Private Sub Initialize()
 
    On Error Resume Next
   
  '------------------------------------------------Global objects  and variables initialization----------------------------------------------
   
    strLogFileName = "RM SafetyNet SSL Certificate (SHA-384).log"
    strGPO = "RM SafetyNet SSL Certificate (SHA-384)"
	strMessageBoxTitle = "RM SafetyNet SSL Certificate (SHA-384) Deployment"
	strGPOUpdateTool = "GPOUpdate.exe"
	strSslCertRegFragment = "RM SafetyNet SSL Certificate (SHA-384).reg"
    strCC4OUName = "Establishments"
    Set ObjRootDSE = GetObject("LDAP://RootDSE") 
    StrDomName = Trim(ObjRootDSE.Get("DefaultNamingContext")) 
  
    set objShell = CreateObject("Wscript.Shell")
    set objFSO = CreateObject("Scripting.FileSystemObject")

    set objGPM = CreateObject("GPMgmt.GPM")
    set objGPMConstants = objGPM.GetConstants()
  
    strErrorMessage = "Error"
	strWarningMessage = "Warning"
    
'------------------------------------------------Global objects and variables initialization----------------------------------------------
 
  Dim strMethodName
  
  strMethodName = "Initialize"
  
  Dim intResult
  
  intResult = MsgBox("Do you want to run this script and deploy a GPO containing the RM SafetyNet SSL Certificate (SHA-384)?", VBOkCancel + vbQuestion, strMessageBoxTitle )
 
  if(intResult = 2) then
     wscript.quit
  end if
	  
  ProgressMsg "The Group Policy Object (GPO) to deploy the certificate is now being created. Please wait as this process may take a few minutes to complete."
  
  GetCurrentDirectory()  
  
  LogMsg "Checking if the executing user has Admin privileges..."	
  IsAdmin()  
  
  LogMsg "Checking if the dependency files exists..."	
  CheckIfDependencyFilesExists()
  
  LogMsg "Getting the domain name..."	
  strDomain = GetDomainName()
  LogMsg "Domain name: " & strDomain		
	
 'Initialize the Domain object
  set objGPMDomain = objGPM.GetDomain(strDomain, "", objGPMConstants.UseAnyDC)
  
  LogMsg "Checking if the GPO '" + strGPO + "' exists..."	
  CheckIfGpoExists()

  CreateGPO()
  
  LogMsg "Setting properties for the GPO '" + strGPO + "'..."			
  SetGpoProperties() 	
  
  LogMsg("Sleeping for 30 seconds for AD replication before updating the GPO '" + strGPO + "' (run 'GPOUpdate' tool)...")
  WScript.Sleep(30000)
  
  LogMsg "Updating the GPO '" + strGPO + "' (run 'GPOUpdate' tool)..."
  UpdateGPO()
 
  LogMsg "Linking the GPO '" + strGPO + "' to domain object..."		
  LinkGPOToDomainObject()
  
  LogMsg("Sleeping for 30 sec for AD replication before applying the policies (call 'gpupdate /force')...")
  WScript.Sleep(30000) 

  LogMsg "Applying the policies..." 
  UpdatePolicies()
   
  if Err.Number then
	 Call LogError ("Error occurred.", strMethodName, strErrorMessage, false, "")
  else
     LogMsg "Successfully completed all operations."
	 ProgressMsg ""
	 Call MsgBox("The GPO has been successfully created. To ensure the GPO is deployed to domain-joined Windows stations, either run gpupdate /force from an administrative command prompt, or restart the station.", vbInformation, strMessageBoxTitle)
  end if 
  
  LogMsg "---------------------End of Opearation--------------------------"
 
End Sub
	
'---------------------------------------------
'Check whether the GPO already exists or not
'---------------------------------------------

Private Sub CheckIfGpoExists()

  On Error Resume Next

  Dim SafetyNetGpo, objGPMSearchCriteria, objGPOList, strMethodName
 
  strMethodName = "CheckIfGpoExists"
  
  set objGPOList = GetGPOList()
  
  If Err.Number Then	    
        Call LogError("Error while getting GPO list object. Check whether Active Directory is set up and GPMC is installed.", strMethodName, strErrorMessage, false, "")
  else
        LogMsg "Successfully got GPO list object."
  End If 
    
  if objGPOList.Count = 1 then
   	Call LogError("The GPO" & " '" & strGPO & "' " & "already exists.", strMethodName, strWarningMessage, false, "")
  elseif objGPOList.Count > 1 then
    Call LogError("Found more than one matching GPO. Count: " & objGPOList.Count, strMethodName, strWarningMessage, false, "")
  else
    LogMsg "The GPO" & " '" & strGPO & "' " & "doesn't exist and hence preparing to create it..."
  end if
	
End Sub

'---------------------------------------------
'Create the GPO
'---------------------------------------------

Private Sub CreateGPO()

  On Error Resume Next
   
  Dim objGPO, strMethodName
  
  strMethodName = "CreateGPO"
  
  set objGPO = objGPMDomain.CreateGPO()

  if Err.Number then
    Call LogError("Failed to create the GPO." & " " & "'" & strGPO & "'", strMethodName, strErrorMessage, false, "")    
  else
    LogMsg("Successfully created the GPO" & " " & "'" & strGPO & "'")
  end if

  objGPO.DisplayName = strGPO

  if Err.Number then
    Call LogError("Failed to set the GPO name." & " " & strGPO, strMethodName, strErrorMessage, false, "")    
  else
    LogMsg "Successfully set the GPO name to" & " " & "'" & strGPO & "'"
  end if
  
End Sub

'---------------------------------------------
'Set properties for the Safety Net GPO
'---------------------------------------------

Private Sub SetGpoProperties()

  On Error Resume Next
   
  Dim boolUserEnable, boolCompEnable, objGPOList, strMethodName

  strMethodName = "SetGpoProperties"
  
  boolUserEnable = False
  boolCompEnable = True
  
  set objGPOList = GetGPOList()
  
  If Err.Number Then
	  Call LogError("Error while getting the GPO list object.", strMethodName, strErrorMessage, true, "getting GPO list object failed")
  else
        LogMsg "Successfully got the GPO list object."
  End If 
    
  if objGPOList.Count = 1 then
   objGPOList.Item(1).SetUserEnabled boolUserEnable
   LogMsg "Successfully set the user settings to " & boolUserEnable
   objGPOList.Item(1).SetComputerEnabled boolCompEnable
   LogMsg "Successfully set the computer settings to " & boolCompEnable
  elseif objGPOList.Count > 1 then
    Call LogError("Found more than one matching GPO. Count: " & objGPOList.Count, strMethodName, strWarningMessage, false, "")
  else
   Call LogError("The GPO" & " '" & strGPO & "' " & "doesn't exist.", strMethodName, strErrorMessage, false, "")
  end if 
	
End Sub

'---------------------------------------------
'Link the GPO to Domain object
'---------------------------------------------
Private Sub LinkGPOToDomainObject()

 On Error Resume Next
 
  Dim strMethodName, objGPOList, objSOM, intLinkPos
  
  intLinkPos = -1 ' set this to the position the GPO evaluated at
	                ' a value of -1 signifies appending it to the end of the list
  
  strMethodName = "LinkGPOToDomainObject"
  
  set objGPOList = GetGPOList()
  
  If Err.Number Then
	   Call LogError("Error while getting the GPO list object.", strMethodName, strErrorMessage, true, "error occurred while getting the GPO list objects")
  else
        LogMsg "Successfully got the GPO list object."
  End If 
  
  set objSOM = objGPMDomain.GetSOM(StrDomName)
  
  If Err.Number Then
	   Call LogError("Error while getting the scope of management (SOM).", strMethodName, strErrorMessage, true, "error occurred while getting SOM")
   else
        LogMsg "Successfully got the scope of management (SOM) for the object " & " '" & StrDomain & "'"
  End If 
	
	if IsNull(objSOM) then
	   Call LogError("Didn't find the object " & " '" & strDomain & "'", strMethodName, strErrorMessage, true, "the object " & " '" & strDomain & "' could not be found")	   	   
	else
	   LogMsg "Found the object: " & objSOM.Name
	end if
  	 
	set objGPMLink = objSOM.CreateGPOLink(intLinkPos, objGPOList.Item(1) ) 'Create GPO Link to domain
	 
	 If Err.Number Then
	   Call LogError("Error while linking the GPO " & " '" & strGPO & "'" & " to the object " & " '" & strDomain & "'" & "!", strMethodName, strErrorMessage, true, "linking the GPO " & " '" & strGPO & "'" & " to the object " & " '" & strDomain & "' failed")
    End If 
	
	LogMsg "Successfully linked the GPO " & " '" & strGPO & "'" & " to to the object " & " '" & strDomain & "'"  & "!"	
	
	Call EnforceGPOLinkSettings(objGPOList.Item(1), objSOM) 'Enforce GPO link settings so that it will override any GPO inheritance is blocked at any level.
    
End Sub

'---------------------------------------------
' Enforce the GPO link settings
'---------------------------------------------
private Sub EnforceGPOLinkSettings(objGPOSSLCert, objSOMForDomain)
 
  On Error Resume next
  
  Dim strMethodNeme
  
  strMethodName = "EnforceGPOLinkSettings"
  
		LogMsg "The SOM Name: " & objSOMForDomain.Name
		
	       if strcomp(objSOMForDomain.Name, strDomain, vbTextCompare) = 0 then
		   
	          set colGPOLinks = objSOMForDomain.getGPOLinks( )
			   
			  If Err.Number Then
	            Call LogError("Error while getting the GPO links for" & " '" & strGPO & "'", strMethodName, strErrorMessage, true, "getting the GPO links for '" & strDomain & "' failed")
              End If 
			  
			  LogMsg "Successfully got the GPO links."
			  
			   LogMsg "The GPO link counts for " & " '" & strDomain & "':"  & colGPOLinks.Count
			   
	           for each objGPOLink in colGPOLinks
			   
	               if strcomp(objGPOLink.GPOID,objGPOSSLCert.ID,vbTextCompare) = 0 then
	                   objGPOLink.Enforced = true
					   
					    If Err.Number Then
	                      Call LogError("Error while enforcing the GPO link settings for" & " '" & strGPO & "'", strMethodName, strErrorMessage, true, "enforcing the GPO link settings for" & " '" & strGPO & " failed")
                        End If 
				  
	                   LogMsg "Successfully enforced the GPO link settings  for " & " '" & strGPO & "'"
					   
					   Exit For ' Exit loop as we need to enforce GPO link settings for the newly created GPO
	
	               end if			  
	           next
	       end if  
End sub

'---------------------------------------------
' Get GPO list object
'---------------------------------------------
Private function GetGPOList()

  Dim objGPMSearchCriteria

  set objGPMSearchCriteria = objGPM.CreateSearchCriteria
  
  objGPMSearchCriteria.Add objGPMConstants.SearchPropertyGPODisplayName, objGPMConstants.SearchOpEquals, cstr(strGPO)
  
  set GetGPOList = objGPMDomain.SearchGPOs(objGPMSearchCriteria)   
  
End function

'----------------------------------------------------------------------------------
'Update the Safety Net GPO with the reg fragment of the certificate to be deployed
'----------------------------------------------------------------------------------

Private Sub UpdateGPO

  On Error Resume Next
 
  Dim param, GpoUpdateTool, strMethodName, intResult
  
  strMethodName = "UpdateGPO"
  
  LogMsg "The Current directory: " & CurrentExecutionDirectory
  
  GpoUpdateTool = """" & CurrentExecutionDirectory & "\" & strGPOUpdateTool & """"
    
  LogMsg "The GPO update tool path: " & GpoUpdateTool
  
  param = """" & strGPO & """ " & """" & CurrentExecutionDirectory & "\" & strSslCertRegFragment & """" & " " & "/abs" & " " & "/machine"
  
  LogMsg "Param to GPO update tool: " & param

  intResult = objShell.Run(GpoUpdateTool & " " & param, 1, True)
   
  LogMsg "Run the tool. Exit Code: " & intResult
   
  If intResult <> 0 Or Err.Number then
      Call LogError("Failed to update the GPO" & " '" & strGPO & "' " & "with the registry fragment of the certificate to be installed.", strMethodName, strErrorMessage, true, "GPO Update failed")
  Else
      LogMsg "Successfully updated the GPO" & " '" & strGPO & "' " & "with the registry fragment of the certificate to be installed."
  End If 
			
End Sub

'-----------------------------------------------------
' Directory in which this script is currently running
'-----------------------------------------------------

Private Function GetCurrentDirectory()

    On Error Resume Next
  
    Dim  wshell, strMethodName
    
	strMethodName = "GetCurrentDirectory"
	
    objShell.CurrentDirectory = objFSO.GetParentFolderName(Wscript.ScriptFullName)
	
    set wshell = createobject("wscript.shell")
	
    CurrentExecutionDirectory = wshell.currentdirectory
	
	LogMsg "------------------------Initializing------------------------------" 
	  
	If Err.Number then
	  Call LogError("Failed to get the current directory!", strMethodName, strErrorMessage, false, "")
	else
	  LogMsg "Successfully got the current directory: " & CurrentExecutionDirectory
    end if 
  
End Function

'-----------------------------------------------------
'Get the network domain name
'-----------------------------------------------------

Private Function GetDomainName()

  Dim Info, strMethodName 
  
  strMethodName = "GetDomainName"
  
  On Error Resume Next 
  
  Set Info = CreateObject("AdSystemInfo")  
  GetDomainName = Info.DomainDNSName   

  If Err.Number then
	Call LogError("Error while getting domain name", strMethodName, strErrorMessage, false, "")
  end if 
  
  LogMsg "Successfully got the domain name."
  
End Function 



'--------------------------------------------------------------------
'Check if the SafetyNetCertDeploy.reg file and GPOUpdate tool exists
'--------------------------------------------------------------------

Private Sub CheckIfDependencyFilesExists()

   Dim strMethodName
   
   strMethodName = "CheckIfDependencyFilesExists"
   
   LogMsg "GPO update file name: " & strGPOUpdateTool
   LogMsg "GPO update file Path: " & CurrentExecutionDirectory & "\" & strGPOUpdateTool
   
  'Check if GPOUpdate tool exists
  If Not (objFSO.FileExists(CurrentExecutionDirectory & "\" & strGPOUpdateTool)) then
    Call LogError("Couldn't find the file " & "'" & CurrentExecutionDirectory & "\" & strGPOUpdateTool & "'", strMethodName, strWarningMessage, false, "")
  end if
  
  LogMsg "Cert reg fragment file name: " & strSslCertRegFragment
  LogMsg "Cert reg fragment file Path: " & CurrentExecutionDirectory & "\" & strSslCertRegFragment
   
  'Check if SafetyNetCertDeploy.reg file exists
  If Not (objFSO.FileExists(CurrentExecutionDirectory & "\" & strSslCertRegFragment)) then
    Call LogError("Couldn't find the file " & "'" & CurrentExecutionDirectory & "\" & strSslCertRegFragment & "'", strMethodName, strWarningMessage, false, "")
  end if
  
  LogMsg "All the file dependencies exist."  

End Sub 

'-----------------------------------------------------
'Update the policies by calling gpupdate /force.
'-----------------------------------------------------

Private Sub UpdatePolicies()

  set wshShell = createObject("Wscript.Shell")
  wshShell.Run "gpupdate /force", 0, true
   
  If Err.Number then
	Call LogError("Error while applying the group policies", "UpdatePolicies", strErrorMessage, false, "")
  end if 
  
 LogMsg "Applied the group policies successfully."
 
End Sub

'----------------------------------------------------------------
' Delete the GPO which was created in case the GPO update fails
'----------------------------------------------------------------
Private Sub DeleteGPO()
   
   On Error Resume Next
   
   Dim strMethodName
   
   strMethodName = "DeleteGPO"

  ' Find the GPO
    set objGPMSearchCriteria = objGPM.CreateSearchCriteria
    objGPMSearchCriteria.Add objGPMConstants.SearchPropertyGPODisplayName, objGPMConstants.SearchOpEquals, cstr(strGPO)
    set objGPOList = objGPMDomain.SearchGPOs(objGPMSearchCriteria)
  
   if Err.Number then
	   Call LogError("Error occurred while checking if the GPO already exists:" & " " & "'" & strGPO & "'", strMethodName, strErrorMessage, false, "")
   end if 
  
  if objGPOList.Count = 1 then
   	Call LogMsg("Found the GPO" & " '" & strGPO & "'")
  elseif objGPOList.Count > 1 then
    Call LogError("Found more than one matching GPO. Count: " & objGPOList.Count, strMethodName, strWarningMessage, false, "")
  else
    Call LogError("The GPO" & " '" & strGPO & "'" &  "doesn't exist.", strMethodName, strErrorMessage, false, "")
  end if
	'  
 'Delete the GPO
	objGPOList.Item(1).Delete
	LogMsg "Successfully deleted the GPO " & "'" & strGPO & "'"
	
End Sub
'-----------------------------------------------------------------
' Check if the user who run this script has got admin privileges
'-----------------------------------------------------------------
Private Function IsAdmin()
 
    On Error Resume Next
	
    Dim shell, strMethodName
	
	strMethodName = "IsAdmin"
	
    Set shell = CreateObject("WScript.Shell")
	
    IsAdmin = false
	
    errorLevel = shell.Run("%comspec% /c net session >nul 2>&1", 0, True)
	
    if errorLevel = 0 then
        IsAdmin = true
		LogMsg "The current user is an Administrator."
	else
	    Call LogError("The current user is not an Administrator! User should have Administrator privileges to run this script.", strMethodName, strWarningMessage, false, "")
    End If
	
	If Err.Number then
	  Call LogError("Error while checking if the user has administrator privileges", strMethodName, strErrorMessage, false, "")
    end if 
  
End Function

'---------------------------------------------
' Write a message to a log file
'---------------------------------------------
Private Sub LogMsg(sMsg)

	On Error Resume Next

	Dim a, sFile
	
	sFile = CurrentExecutionDirectory & "\" & strLogFileName
	
   	Set a = objFSO.OpenTextFile(sFile, 8, True)
	
	If Err.Number then
	  Call PopUp("Error while creating/opening log file", "Error")
    end if 
  
    a.WriteLine (Date & " " & Time & " - " & sMsg)
    	
    If Err.Number then
	  Call PopUp("Error while writing to log file", "Error")
    end if 
	
  	a.Close

End Sub

'---------------------------------------------
' Error logging
'---------------------------------------------
Private function LogError(sInsert, strMethodName, strMode, IsDeleteGPO, strDeleteGPOMessage)	 
	 
	 if Not (Err = "") Or IsNull(Err) then
	  if Not (Err.Number = 0) then
	   sMsg = strMode & "! " & "Method name: " & strMethodName & " " & "Custom Message: " & sInsert & ": Error 0x: " & CStr(Err.Number) & " Description: " & Err.Description & "." & " Exiting..."
  	   LogMsg sMsg
	  else
	    sMsg = strMode & "! " & "Method name: " & strMethodName & " " & "Custom Message: " & sInsert & ". Exiting..."
  	   LogMsg sMsg
      end if  
  	 end if
	 
	 ProgressMsg ""
	 
	 if(IsDeleteGPO) then
	   LogMsg "Deleting the GPO " & " '" & strGPO & "'" & " "  & "as " & strDeleteGPOMessage & "..."
	   DeleteGPO() 'Delete the GPO
	 end if	 
	 
	Err.Clear
	
	 on error resume next
	 Call PopUp(sInsert, strMode)
	 if Err.Number then
	      Err.Clear
	 	  wscript.quit
     end if
		
End function

'---------------------------------------------
' Pop up message box
'---------------------------------------------
Private Sub PopUp(strMessage, strMode)
    
    If(strMode = strErrorMessage) then
      Call MsgBox("There was an error deploying the certificate and the process did not complete. Please follow the manual deployment instructions to create the Group Policy Object to deploy the certificate.", vbCritical, strMessageBoxTitle)
	elseIf(strMode = strWarningMessage) then
	  Call MsgBox(strMessage & VbCrLf & "Check the log file for more information at " & "'" & CurrentExecutionDirectory & "\" & strLogFileName & "'", vbExclamation, strMessageBoxTitle)	  
	End if	
	
	ProgressMsg ""
	
	Wscript.quit
	
End Sub

'---------------------------------------------
' Progress message box
'---------------------------------------------
Function ProgressMsg( strMessage)

    Set wshShell = WScript.CreateObject( "WScript.Shell" )
    strTEMP = wshShell.ExpandEnvironmentStrings( "%TEMP%" )
	
    If strMessage = "" Then
        On Error Resume Next
        objProgressMsg.Terminate( )
		
        On Error Goto 0
        Exit Function
    End If
	
    Set objFSOProgressMsg = CreateObject("Scripting.FileSystemObject")
    strTempVBS = strTEMP + "\" & "Message.vbs"

    Set objTempMessage = objFSO.CreateTextFile( strTempVBS, True )
    objTempMessage.WriteLine( "MsgBox""" & strMessage & """, 64, """ & strMessageBoxTitle & """" )
    objTempMessage.Close

    On Error Resume Next
    objProgressMsg.Terminate( )
	
    On Error Goto 0

    Set objProgressMsg = WshShell.Exec( "%windir%\system32\wscript.exe " & strTempVBS )
	
End Function